<?php
namespace Banyo\BlogUrlCustomizer\Helper;

use Mageplaza\Blog\Helper\Data as MageplazaBlogHelper;

class Data extends MageplazaBlogHelper
{
    const CATEGORY_URL_SUFFIX = '';

    /**
     * @param null $urlKey
     * @param null $type
     * @param null $store
     *
     * @return string
     */
    public function getBlogUrl($urlKey = null, $type = null, $store = null)
    {
        if (is_object($urlKey)) {
            $urlKey = $urlKey->getUrlKey();
        }

        $route = $this->getRoute($store);

        // Skip "post/" only if route = article and type = post
        if ($type === self::TYPE_POST && $route === 'article') {
            // leave $urlKey unchanged
        } else {
            $urlKey = ($type ? $type . '/' : '') . $urlKey;
        }

        $url = $this->getUrl($route . '/' . $urlKey);
        $url = explode('?', $url ?? '');
        $url = $url[0];

        // Use the URL suffix from admin configuration
        $urlSuffix = $this->getUrlSuffix($store);

        return rtrim($url, '/') . $urlSuffix;
    }
}
