<?php declare (strict_types=1);

namespace Banyo\CustomHomePage\Setup\Patch\Data;

use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Model\Entity\Attribute\Source\Boolean;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Catalog\Model\Category;

/**
 * Class AddCategorySlideSvg for creating custom category attribute to store SVG code.
 */
class AddCategorySlideSvg implements DataPatchInterface
{
    const CATEGORY_SLIDE_SVG_CODE = 'shop_by_category_svg_code';

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        private ModuleDataSetupInterface $moduleDataSetup,
        private EavSetupFactory $eavSetupFactory
    ) {
    }

    /**
     * {@inheritdoc}
     */
    public function apply(): void
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $eavSetup->addAttribute(Category::ENTITY, self::CATEGORY_SLIDE_SVG_CODE,
            [
                'type' => 'text',
                'label' => 'Svg category slider on homepage Mobile devices',
                'note'  => 'Provide Svg icons for category slider for mobile devices on homepage ',
                'system' => 0,
                'input' => 'textarea',
                'sort_order' => 333,
                'source' => Boolean::class,
                'visible' => true,
                'required' => false,
                'user_defined' => true,
                'default' => null,
                'global' => ScopedAttributeInterface::SCOPE_STORE,
                'group' => 'General Information',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases(): array
    {
        return [];
    }
}
