<?php

namespace Banyo\CustomHomePage\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Store\Model\ScopeInterface;

class CustomerSupport implements ArgumentInterface
{
    private const XML_PATH_WE_GET_IT = 'nexus_theme/support_customer/';

    public function __construct(
        private ScopeConfigInterface $scopeConfig,
        private StoreManagerInterface $storeManager
    ) {
    }

    protected function getMediaUrl(): string
    {
        return rtrim(
                $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA),
                '/'
            ) . '/';
    }

    public function getImageUrl(string $configPath): ?string
    {
        $value = $this->scopeConfig->getValue($configPath, ScopeInterface::SCOPE_STORE);

        if ($value) {
            $mediaUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
            return $mediaUrl . 'wysiwyg/' . ltrim($value, '/');
        }

        return null;
    }
}
