<?php

declare(strict_types=1);

namespace Banyo\CustomHomePage\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Store\Model\ScopeInterface;

class HeroSlider implements ArgumentInterface
{
    public function __construct(
        private ScopeConfigInterface $scopeConfig,
        private StoreManagerInterface $storeManager
    ) {}

    public function getSlideImageUrl(string $configPath): ?string
    {
        $value = $this->scopeConfig->getValue($configPath, ScopeInterface::SCOPE_STORE);

        if ($value) {
            $mediaUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
            return $mediaUrl . 'wysiwyg/' . ltrim($value, '/');
        }

        return null;
    }
}
