<?php

namespace Banyo\CustomHomePage\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Catalog\Model\Category;
use Magento\Store\Model\ScopeInterface;

class ShopByCategory implements ArgumentInterface
{
    private CollectionFactory $categoryCollectionFactory;
    private StoreManagerInterface $storeManager;
    private ScopeConfigInterface $scopeConfig;

    public function __construct(
        CollectionFactory $categoryCollectionFactory,
        StoreManagerInterface $storeManager,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->storeManager = $storeManager;
        $this->scopeConfig = $scopeConfig;
    }

    public function getHomeCategories()
    {
        $store = $this->storeManager->getStore();
        $rootCategoryId = $store->getRootCategoryId();

        return $this->categoryCollectionFactory->create()
            ->addAttributeToSelect([
                'name',
                'image',
                'mobile_image',
                'is_home',
                'url_key',
                'url_path',
                'shop_by_category_svg_code' // explicitly added here
            ])
            ->addAttributeToFilter('is_home', ['eq' => 1])
            ->addAttributeToFilter('path', ['like' => "1/{$rootCategoryId}/%"])
            ->setOrder('position', 'ASC');
    }

    public function getConfigValue(string $key): ?string
    {
        return $this->scopeConfig->getValue(
             $key,
            ScopeInterface::SCOPE_STORE
        );
    }

}

