<?php
namespace Banyo\CustomHomePage\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\BlockRepository;

class StoreContent implements ArgumentInterface
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @var BlockFactory
     */
    private $blockFactory;

    /**
     * @var BlockRepository
     */
    private $blockRepository;

    /**
     * @param StoreManagerInterface $storeManager
     * @param ScopeConfigInterface $scopeConfig
     * @param BlockFactory $blockFactory
     * @param BlockRepository $blockRepository
     */
    public function __construct(
        StoreManagerInterface $storeManager,
        ScopeConfigInterface $scopeConfig,
        BlockFactory $blockFactory,
        BlockRepository $blockRepository
    ) {
        $this->storeManager = $storeManager;
        $this->scopeConfig = $scopeConfig;
        $this->blockFactory = $blockFactory;
        $this->blockRepository = $blockRepository;
    }

    /**
     * Get tabs configuration
     *
     * @return array
     */
    public function getTabs(): array
    {
        // Get current store ID
        $storeId = $this->storeManager->getStore()->getId();

        // Base tab configuration with common IDs but store-specific block IDs and mobile titles
        $tabsConfig = [
            [
                'id' => 'tab-1',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_1' : '1', // Use different block ID for Nexus store
                'mobile_title' => $storeId == 2 ? 'About Nexus' : 'About Banyo'
            ],
            [
                'id' => 'tab-2',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_2' : '2',
                'mobile_title' => $storeId == 2 ? 'Boss your Nexus Bathroom' : 'Boss your Bathroom'
            ],
            [
                'id' => 'tab-3',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_3' : 'home_tab_3',
                'mobile_title' => $storeId == 2 ? 'Renovate with Nexus' : 'Renovate your Bathroom'
            ],
            [
                'id' => 'tab-4',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_4' : 'home_tab_4',
                'mobile_title' => $storeId == 2 ? 'Nexus Fresh Look' : 'Fresh New Look'
            ],
            [
                'id' => 'tab-5',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_5' : 'home_tab_5',
                'mobile_title' => $storeId == 2 ? 'Nexus Shopping Made Easy' : 'Shopping Made Easy'
            ],
            [
                'id' => 'tab-6',
                'block_id' => $storeId == 2 ? 'nexus_home_tab_6' : 'home_tab_6',
                'mobile_title' => $storeId == 2 ? 'Nexus Customer First' : 'Customer First Thinking'
            ]
        ];

        $tabs = [];
        foreach ($tabsConfig as $tab) {
            $blockTitle = $this->getBlockTitle($tab['block_id']);
            $tabs[] = [
                'id' => $tab['id'],
                'title' => $blockTitle ?: $tab['mobile_title'],
                'block_id' => $tab['block_id'],
                'mobile_title' => $blockTitle ?: $tab['mobile_title'] // Use block title for mobile title as well
            ];
        }

        return $tabs;
    }

    /**
     * Get CMS block title by block ID
     *
     * @param string $blockId
     * @return string|null
     */
    private function getBlockTitle(string $blockId): ?string
    {
        try {
            $block = $this->blockRepository->getById($blockId);
            return $block->getTitle();
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * Check if CMS block exists
     *
     * @param string $blockId
     * @return bool
     */
    public function blockExists(string $blockId): bool
    {
        try {
            $this->blockRepository->getById($blockId);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }
}
