<?php
namespace Banyo\CustomProduct\Block;

use Mirasvit\Brand\Block\Logo as MirasvitLogo;
use Magento\Framework\App\Request\Http as RequestHttp;
use Magento\Framework\View\Element\Template\Context;
use Mirasvit\Brand\Model\Config\Config;
use Mirasvit\Brand\Service\BrandLogoService;
use Magento\Framework\UrlInterface;
use Mirasvit\Brand\Repository\BrandPageRepository;
use Magento\Framework\Registry;
use Magento\Catalog\Model\Product;

class Logo extends MirasvitLogo
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @var BrandPageRepository
     */
    private $brandPageRepository;

    /**
     * @var Registry
     */
    private $registry;

    /**
     * @param Context $context
     * @param BrandLogoService $brandLogoService
     * @param Config $config
     * @param RequestHttp $request
     * @param UrlInterface $urlBuilder
     * @param BrandPageRepository $brandPageRepository
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        BrandLogoService $brandLogoService,
        Config $config,
        RequestHttp $request,
        UrlInterface $urlBuilder,
        BrandPageRepository $brandPageRepository,
        Registry $registry,
        array $data = []
    ) {
        parent::__construct($context, $brandLogoService, $config, $request, $data);
        $this->urlBuilder = $urlBuilder;
        $this->brandPageRepository = $brandPageRepository;
        $this->registry = $registry;
    }

    /**
     * Get the product page brand logo URL
     *
     * @return string
     */
    public function getProductPageLogoImageUrl()
    {
        // Get the current brand's attribute option ID
        $optionId = null;

        // If we're on a product page, get the brand ID from the current product
        if ($this->isProductPage()) {
            $product = $this->registry->registry('current_product');
            if ($product) {
                $brandAttributeCode = $this->config->getBrandAttribute();
                $optionId = $product->getData($brandAttributeCode);
            }
        } else {
            // Otherwise, try to get it from the request parameters
            $optionId = $this->getRequest()->getParam('option_id');
        }

        if (!$optionId) {
            return '';
        }

        // Get the brand page from the repository
        $brandPage = $this->brandPageRepository->getCollection()
            ->addFieldToFilter('attribute_option_id', $optionId)
            ->getFirstItem();

        if (!$brandPage->getId()) {
            return '';
        }

        // Get the brand_product_page_logo field
        $logo = $brandPage->getData('brand_product_page_logo');
        if (!$logo) {
            return '';
        }

        // If it's an array, extract the URL
        if (is_array($logo) && isset($logo[0]['url'])) {
            return $logo[0]['url'];
        }

        // Otherwise, construct the URL
        return $this->urlBuilder->getBaseUrl(['_type' => UrlInterface::URL_TYPE_MEDIA]) . 'brand/logo/' . ltrim($logo, '/');
    }
}
