<?php
declare(strict_types=1);

namespace Banyo\CustomProduct\Controller\Ajax;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\View\LayoutFactory;

class ProductInfo extends Action
{
    public function __construct(
        Context $context,
        private readonly CustomerSession $customerSession,
        private readonly ProductRepositoryInterface $productRepository,
        private readonly LayoutFactory $layoutFactory
    ) {
        parent::__construct($context);
    }

    public function execute()
    {
        $status = $this->customerSession->isLoggedIn() ? 'logged_in' : 'guest';

        return $this->resultFactory->create(ResultFactory::TYPE_RAW)
            ->setHeader('Cache-Control', 'no-store, no-cache, must-revalidate', true)
            ->setContents($status);

    }
}
