<?php
declare(strict_types=1);

namespace Banyo\SeoFix\Plugin;

use Magento\Framework\View\Page\Config;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\UrlInterface;

class OgImagePlugin
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    /**
     * Replace og:image meta tag with custom URL
     *
     * @param Config $subject
     * @param \Closure $proceed
     * @param string $name
     * @param string $content
     * @return mixed
     */
    public function aroundAddRemotePageAsset(
        Config $subject,
        \Closure $proceed,
        $name,
        $content,
        $attributes = [],
        $contentType = null
    ) {
        // Only modify og:image meta tag
        if (isset($attributes['property']) && $attributes['property'] === 'og:image') {
            // Replace the content with our custom URL
            $content = $this->storeManager
                    ->getStore()
                    ->getBaseUrl(UrlInterface::URL_TYPE_MEDIA)
                . 'logo/stores/1/BanyoStoreLogo.png';
        }

        // Call the original method with our modified parameters
        return $proceed($name, $content, $attributes, $contentType);
    }
}
