<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

namespace Mageants\SimpleConfigurable\Observer\Adminhtml;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class Product implements ObserverInterface
{
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    public $request;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;

    /**
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\Json\Helper\Data $jsonHelper
     */
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\Json\Helper\Data $jsonHelper
    ) {
        $this->request = $request;
        $this->jsonHelper = $jsonHelper;
    }

    /**
     * @inheritdoc
     */
    public function execute(Observer $observer)
    {
        $pdata = $this->request->getPost();
        if (isset($pdata['configurable-matrix-serialized']) && $pdata['configurable-matrix-serialized']) {
            $product = $observer->getEvent()->getProduct();
            $simpleProducts = $this->jsonHelper->jsonDecode($pdata['configurable-matrix-serialized']);
            foreach ($simpleProducts as $simpleProduct) {
                if (isset($simpleProduct['checked']) && $simpleProduct['checked']) {
                    $product->setStoreId($product->getStoreId())
                        ->setData('is_default_selected', $simpleProduct['id'])
                        ->save();
                }
            }
        }
        return true;
    }
}
