<?php
namespace Nexus\Catalog\Block;
use Magento\Store\Model\ScopeInterface;
class BrandCategory extends \Magento\Framework\View\Element\Template 
{
	protected $categoryFactory;		
	public function __construct(
      	\Magento\Catalog\Block\Product\Context $context,
		\Magento\Catalog\Model\CategoryFactory $categoryFactory,
		\Magento\Store\Model\StoreManagerInterface $storeManagerInterface,
      	array $data = []
    ) 
	{

		$this->categoryFactory = $categoryFactory;
		$this->_storeManager = $storeManagerInterface;
	  	parent::__construct($context,$data);
		
	}
	
	public function _getallbrandCollection()
	{ 
		$alphabet = $this->getbrandnameAlphabetically();
		$allbrandCollection = array();
	 	ksort($alphabet);
		foreach ($alphabet  as $row): 
            
			
		
				
				if($this->_storeManager->getStore()->getId()==1){
					$subCategory = $this->categoryFactory->create()->load(33);
					$subCats = $subCategory->getAllChildren(true);
					$allbrandCollection[$row] = $this->categoryFactory->create()->getCollection()->addAttributeToSelect('*')->	addAttributeToFilter('name', array('like' => $row.'%'))->addAttributeToFilter('is_active','1')->addAttributeToFilter('parent_id', array('eq' => 33))->addAttributeToSort('name', 'asc')->setStoreId($this->_storeManager->getStore()->getId());
				}elseif($this->_storeManager->getStore()->getId()==3){
					$subCategory = $this->categoryFactory->create()->load(1277);
					$subCats = $subCategory->getAllChildren(true);
					$allbrandCollection[$row] = $this->categoryFactory->create()->getCollection()->addAttributeToSelect('*')->	addAttributeToFilter('name', array('like' => $row.'%'))->addAttributeToFilter('parent_id', array('eq' => 1277))->addAttributeToSort('name', 'asc')->addAttributeToFilter('is_active','1')->setStoreId($this->_storeManager->getStore()->getId());

				}
				
		endforeach;
		return $allbrandCollection;
	
	}
	
	
	public function getbrandnameAlphabetically() {
		//Nexus Brand Category
		if($this->_storeManager->getStore()->getId()==1){
			$subCategory = $this->categoryFactory->create()->load(33);
			$subCats = $subCategory->getAllChildren(true);
			$allbrandCollection = $this->categoryFactory->create()->getCollection()->addAttributeToSelect('*')->	addAttributeToFilter('entity_id', array('in' => $subCats))->addAttributeToFilter('is_active','1')->addAttributeToFilter('parent_id', array('eq' => 33))->addAttributeToSort('name', 'asc')->setStoreId($this->_storeManager->getStore()->getId());
		}elseif($this->_storeManager->getStore()->getId()==3){
			$subCategory = $this->categoryFactory->create()->load(1277);
			$subCats = $subCategory->getAllChildren(true);
			$allbrandCollection = $this->categoryFactory->create()->getCollection()->addAttributeToSelect('*')->	addAttributeToFilter('entity_id', array('in' => $subCats))->addAttributeToFilter('is_active','1')->addAttributeToFilter('parent_id', array('eq' => 1277))->addAttributeToSort('name', 'asc')->setStoreId($this->_storeManager->getStore()->getId());
		}

			$brandcollection= array();
			foreach($allbrandCollection as $subcat) {
			

			$brnm= substr($subcat->getName(), 0, 1);
			$brnm = strtoupper($brnm);
			 if(!array_key_exists(trim($brnm), $brandcollection)){	$brandcollection[trim($brnm)]=$brnm;} 
		}
		return $brandcollection;
	}
}
