<?php
namespace Nexus\Catalog\Cron;

class BackInStock
{
    
    public function __construct(       
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory        
    )
    {   
        $this->_productCollectionFactory = $productCollectionFactory;       
    }   
    public function execute()
    { 
        
        $collection = $this->_productCollectionFactory->create();
        $collection->addAttributeToSelect('due_date');
        $collection->addAttributeToSelect('back_in_stock');
        $collection->addAttributeToFilter('back_in_stock',true);               
        $collection->addAttributeToFilter('due_date',['lteq'=>date("Y-m-d h:i:s")]);
            
        if($collection->count())
        { 
            foreach ($collection as $product) {
                
                 $product->setData('back_in_stock',0);
                 $product->setData('due_date',"");                                  
                 $product->setStockData(array('use_config_manage_stock' => 1,'manage_stock' => 1,'is_in_stock' => 1,'qty' => 100));
                 $product->save();
            }            
        }
          
    }
   
}
