<?php

namespace Nexus\Catalog\Model\ResourceModel\CatalogProductLink;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    protected $_idFieldName = 'link_id';

    protected $_eventPrefix = 'nexus_catelog_catalogproductlink_grid_collection';

    protected $_eventObject = 'catalogproductlink_grid_collection';

    protected $_backendSession;
	
	public function __construct(
        \Magento\Backend\Model\Session $backendSession,
		\Magento\Framework\App\Request\Http $request,		
		\Magento\Framework\Data\Collection\EntityFactoryInterface $entityFactory,
		\Psr\Log\LoggerInterface $logger,
        \Magento\Framework\Data\Collection\Db\FetchStrategyInterface $fetchStrategy,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        $connection = null,
        \Magento\Framework\Model\ResourceModel\Db\AbstractDb $resource = null
    )
    {
		$this->_backendSession = $backendSession;
		$this->request = $request;		
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
    }
	
    protected function _construct()
    {
        $this->_init('Nexus\Catalog\Model\CatalogProductLink', 'Nexus\Catalog\Model\ResourceModel\CatalogProductLink');		
    }

  
    public function getSelectCountSql()
    {
        $countSelect = parent::getSelectCountSql();
        $countSelect->reset(\Zend_Db_Select::GROUP);
        return $countSelect;
    } 
	
    protected function _toOptionArray($valueField = 'id', $labelField = 'name', $additional = [])
    {
        return parent::_toOptionArray($valueField, $labelField, $additional);
    }
	
	//Declaring the tables we want to include in the grid
	protected function _initSelect()
    {
       parent::_initSelect();       	
	
    }

}
