<?php

namespace Nexus\Sales\Model\ResourceModel\Order\Orderreports\Grid;

use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Psr\Log\LoggerInterface as Logger;

class Collection extends \Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult
{
	
 /**
     * Initialize dependencies.
     *
     * @param EntityFactory $entityFactory
     * @param Logger $logger
     * @param FetchStrategy $fetchStrategy
     * @param EventManager $eventManager
     * @param string $mainTable
     * @param string $resourceModel
     */
    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        $mainTable = 'sales_order_item',
        $resourceModel = \Magento\Sales\Model\ResourceModel\Order\Item::class
    ) {

        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $mainTable, $resourceModel);
       
        $this->addFilterToMap('created_at','main_table.created_at');
        $this->addFilterToMap('brand','main_table.brand');
         $this->addFilterToMap('increment_id','sog.increment_id');
   
    }
	
	protected function _initSelect()
    {   
       
        $this->getSelect()->from(['main_table' => $this->getTable('sales_order_item')]);
		$this->getSelect()->joinLeft(array('sog' => 'sales_order_grid'),
            'main_table.order_id = sog.entity_id', array('sog.increment_id','sog.customer_name','sog.customer_email', 'sog.status', 'sog.base_grand_total', 'sog.payment_method','sog.grand_total','sog.billing_address','sog.shipping_address','sog.subtotal','sog.shipping_and_handling','sog.total_refunded','sog.billing_name','sog.shipping_name','sog.shipping_information','sog.customer_group','sog.base_currency_code','sog.order_currency_code'));
        
	   
        return $this;
	}

   
    
}